﻿
Public Class MSWordPrintingSession

    Private _WordPrintingSession As WordPrintingSession
    Private _PrintJob As WordPrintingSession.PrintJob
    Private _PrintMode As WordPrintingSession.PrintingMode

    Public Sub New(ByRef PrintSession As WordPrintingSession, ByVal PrintJob As WordPrintingSession.PrintJob)
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
        Me._WordPrintingSession = PrintSession
        Me._PrintJob = PrintJob
    End Sub


    Public Sub DoWork(ByVal PrintMode As WordPrintingSession.PrintingMode)
        Me._PrintMode = PrintMode
        Me.ShowDialog()
    End Sub


    Private Sub MSWordPrintingSession_Shown(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Shown
        Me._WordPrintingSession.DoRepairingJob(Me._PrintJob, Me._PrintMode)
    End Sub


End Class






Public Class WordPrintingSession

#Region "declared"
    Private PrintJobCuonter As Integer = 0
    Private PrintJobCollection As Collection
    Private TemplatesDirectoryPath As String = My.Application.Info.DirectoryPath & "\PrintTemplates\"
    Private TemplateFileName As String
    Private TemplateDirectoryWithFileName As String
    Private OfficeWord As Word.Application
    Private Document As Word.Document
    Private BookMarkCuonter As Integer = 0
    Private LastBookMarkContinues As Word.Bookmark
    Private ImagePath As String = My.Application.Info.DirectoryPath & "\Temp"
    Private m_ImageHasSaved As Boolean
    Private Property ImageHasSaved() As Boolean
        Get
            Return Me.m_ImageHasSaved
        End Get
        Set(ByVal value As Boolean)
            m_ImageHasSaved = value
            PrintingProcess._ImageHasSaved = value
            PrintingProcess._ImagePath = Me.ImagePath
        End Set
    End Property
#End Region

    Public Overloads Sub Dispose()
        Me.Finalize()
        GC.SuppressFinalize(Me)
    End Sub


    Public Function StartUp(ByVal TemplateBinaryData As Byte(), ByVal TemplateName As String) As Boolean
        Try
            Dim FileIsBusy As Boolean = False
            CheckTempFile()
            '-- Set File Names ------------------------------------------
            Me.TemplateDirectoryWithFileName = TemplatesDirectoryPath & "\" & TemplateName & ".dot"
            '-- Check [Directory] Is Exists -----------------------------
            Dim DirectoryExist As Boolean = My.Computer.FileSystem.DirectoryExists(TemplatesDirectoryPath)
            If Not DirectoryExist Then
                My.Computer.FileSystem.CreateDirectory(TemplatesDirectoryPath)
            End If
            '-- Write All Bytes To The [File] ---------------------------
            Try
                My.Computer.FileSystem.WriteAllBytes(TemplateDirectoryWithFileName, TemplateBinaryData, False)
            Catch ex As Exception
                '-- لأنها مؤقتة $$MSOtemp سيتم مسح الملفات التي تبداء بالأسم 
                Me.TemplateDirectoryWithFileName = TemplatesDirectoryPath & "\$$MSOtemp" & Now.Hour.ToString & Now.Minute.ToString & Now.Second.ToString & TemplateName
                FileIsBusy = True
            End Try
            If FileIsBusy Then
                My.Computer.FileSystem.WriteAllBytes(TemplateDirectoryWithFileName, TemplateBinaryData, False)
            End If

            '-- Create [MicroSoft Office Word] Application And Document -----------------------------
            If Not CreateMSWordObject(TemplateDirectoryWithFileName) Then Return False
            '-- If Every Thing Is Ok Return True,, New We Can Write In The Document 
            Return True
        Catch ex As Exception
            PrintingProcess.ShowErrorMsgAndClose(ex.Message)
            Return False
        End Try
    End Function


    Public Function StartUp(ByVal TemplateFilePath As String) As Boolean
        Try
            '-- Check [File] Is Exists ------------------------------
            Dim FileExist As Boolean = My.Computer.FileSystem.FileExists(TemplateFilePath)
            If Not FileExist Then
                MsgBox("لم يتم العثور على الملف :" & vbNewLine & TemplateDirectoryWithFileName, _
                       MsgBoxStyle.Critical + MsgBoxStyle.OkOnly + MsgBoxStyle.MsgBoxRtlReading, "خطاء في فتح الملف")
                Return False
            End If
            '-- Create [MicroSoft Office Word] Application And Document -----------------------------
            If Not CreateMSWordObject(TemplateDirectoryWithFileName) Then Return False
            '-- If Every Thing Is Ok Return True,, Now We Can Write In The Document 
            Return True
        Catch ex As Exception
            PrintingProcess.ShowErrorMsgAndClose(ex.Message)
            Return False
        End Try
    End Function

    Private Sub CheckTempFile()
        For Each File As String In My.Computer.FileSystem.GetFiles(TemplatesDirectoryPath)
            With My.Computer.FileSystem.GetFileInfo(File)
                If .Name.Contains("MSOtemp") Then
                    Try
                        System.IO.File.Delete(File)
                    Catch ex As Exception
                    End Try
                End If
            End With
        Next
    End Sub



    Private Function CreateMSWordObject(ByVal FilePath As String) As Boolean
        Try
            Me.OfficeWord = CreateObject("Word.Application")
            PrintingProcess._OfficeWord = Me.OfficeWord
            Me.OfficeWord.Visible = False
            Me.Document = OfficeWord.Documents.Add(FilePath, True)
            '-- Set Option For MS Word
            Me.OfficeWord.Options.ArabicNumeral = Word.WdArabicNumeral.wdNumeralHindi
            Me.OfficeWord.ActiveWindow.View.ShowBookmarks = False
            Me.OfficeWord.ActiveWindow.View.TableGridlines = False
            Me.OfficeWord.ActiveWindow.View.Type = Word.WdViewType.wdPrintView
            Return True
        Catch ex As Exception
            PrintingProcess.ShowErrorMsgAndClose(ex.Message)
            Return False
        End Try
    End Function

    Enum PrintingMode
        PrintOut = 2
        PrintPrevew = 4
    End Enum


    Private PrintingSessionDialog As MSWordPrintingSession


    Public Function RepairPrintJob(ByVal PrintJob As WordPrintingSession.PrintJob, ByVal PrintMode As PrintingMode) As Boolean
        Me.PrintingSessionDialog = New MSWordPrintingSession(Me, PrintJob)
        Me.PrintingSessionDialog.PrintProgressBar.Maximum = PrintJob.GetPrintJobCuonter
        PrintingProcess._ProgressWindow = PrintingSessionDialog
        PrintingProcess._WordPrintingSession = Me
        Me.PrintingSessionDialog.DoWork(PrintMode)
    End Function





    Public Function DoRepairingJob(ByVal PrintJob As WordPrintingSession.PrintJob, ByVal PrintMode As PrintingMode) As Boolean
        Try
            For Each PrntJob As Object In PrintJob.PrintJobCollection
                '------------------------------------------------------------------------------------
                If TypeOf PrntJob Is WordPrintingSession.BookMarkText Then
                    Dim RepairJob As BookMarkText = PrntJob
                    If Not SelectThisBookMark(RepairJob.BookMarkName) Then Return False
                    Me.OfficeWord.Selection.TypeText(Text:=RepairJob.Text)
                    SetProgressCuonter()
                    '--------------------------------------------------------------------------------
                ElseIf TypeOf PrntJob Is WordPrintingSession.BookMarkImage Then
                    Dim RepairJob As BookMarkImage = PrntJob
                    If Not SelectThisBookMark(RepairJob.BookMarkName) Then Return False
                    WriteImage(RepairJob)
                    SetProgressCuonter()
                    '--------------------------------------------------------------------------------
                ElseIf TypeOf PrntJob Is WordPrintingSession.BookMarkTable Then
                    Dim RepairJob As BookMarkTable = PrntJob
                    If Not WriteTableContaint(RepairJob) Then Return False
                    '--------------------------------------------------------------------------------
                ElseIf TypeOf PrntJob Is WordPrintingSession.BookMarkDeletedTable Then
                    Dim RepairJob As BookMarkDeletedTable = PrntJob
                    If Not SelectThisBookMark(RepairJob.HeadTableBookMarkName) Then Return False
                    Me.OfficeWord.Selection.Tables(1).Select()
                    Me.OfficeWord.Selection.Tables(1).Delete()
                End If
                '------------------------------------------------------------------------------------
                My.Application.DoEvents()
            Next

            If ImageHasSaved Then
                My.Computer.FileSystem.DeleteFile(ImagePath, FileIO.UIOption.OnlyErrorDialogs, FileIO.RecycleOption.DeletePermanently)
            End If
            '-----------------------------------------------
            Me.OfficeWord.Selection.HomeKey(Unit:=Word.WdUnits.wdStory)
            Me.PrintingSessionDialog.Close()

            If PrintMode = PrintingMode.PrintPrevew Then
                Me.OfficeWord.ActiveDocument.PrintPreview()
                Me.OfficeWord.ActiveWindow.ActivePane.View.Zoom.Percentage = 100
                Me.OfficeWord.Visible = True
            Else
                Me.OfficeWord.ActiveDocument.PrintOut()
                Me.OfficeWord.ActiveWindow.Close(False)
            End If

            My.Computer.Clipboard.Clear()
            Return True
        Catch ex As Exception
            PrintingProcess.ShowErrorMsgAndClose(ex.Message)
            Return False
        End Try
    End Function

    Private Sub WriteImage(ByVal PrintImage As BookMarkImage)
        '-- 
        If PrintImage.MaximumSize IsNot Nothing Then
            Dim scale_factor As Single = 1.0
            Dim ImageHasChanged As Boolean = False

            If PrintImage.Image.Height > PrintImage.MaximumSize.Height Then
                ' Reduce height first
                scale_factor = CSng(PrintImage.MaximumSize.Height / PrintImage.Image.Height)
                ImageHasChanged = True
            End If
            If (PrintImage.Image.Width * scale_factor) > PrintImage.MaximumSize.Width Then
                ' Scaled width exceeds Box's width, recalculate scale_factor
                scale_factor = CSng(PrintImage.MaximumSize.Width / PrintImage.Image.Width)
                ImageHasChanged = True
            End If
            If Not ImageHasChanged Then
                GoTo FirsetAction
            End If
            Dim ImageAfterResizing As New Bitmap(PrintImage.Image, _
                                            CInt(PrintImage.Image.Width * scale_factor), _
                                            CInt(PrintImage.Image.Height * scale_factor))
            ImageAfterResizing.Save(ImagePath)
            GoTo SecondAction
        End If
FirsetAction:
        PrintImage.Image.Save(ImagePath)
SecondAction:
        Me.OfficeWord.Selection.InlineShapes.AddPicture(ImagePath)
        If Not ImageHasSaved Then
            ImageHasSaved = True
        End If
        If PrintImage.BorderStyle <> Word.WdLineStyle.wdLineStyleNone Then
            SetImageBorder(PrintImage.BorderStyle, PrintImage.BorderSize, PrintImage.BorderColor)
        End If
    End Sub

    Private Sub SetImageBorder(ByVal BorderStyle As Word.WdLineStyle, ByVal BorderSize As Word.WdLineWidth, ByVal BorderColor As Word.WdColor)
        Try
            Dim PositevBorder As Word.WdLineStyle = BorderStyle
            Dim NegitevBorder As Word.WdLineStyle = GetNigitevBorder(BorderStyle)
            With OfficeWord.ActiveDocument.InlineShapes(OfficeWord.ActiveDocument.InlineShapes.Count)
                With .Borders(Word.WdBorderType.wdBorderTop)
                    .LineStyle = PositevBorder
                    .LineWidth = BorderSize
                    .Color = BorderColor
                End With
                With .Borders(Word.WdBorderType.wdBorderLeft)
                    .LineStyle = PositevBorder
                    .LineWidth = BorderSize
                    .Color = BorderColor
                End With
                With .Borders(Word.WdBorderType.wdBorderRight)
                    .LineStyle = NegitevBorder
                    .LineWidth = BorderSize
                    .Color = BorderColor
                End With
                With .Borders(Word.WdBorderType.wdBorderBottom)
                    .LineStyle = NegitevBorder
                    .LineWidth = BorderSize
                    .Color = BorderColor
                End With
            End With
        Catch ex As Exception
            PrintingProcess.ShowErrorMsgAndClose(ex.Message)
        End Try
    End Sub

    Private Function GetNigitevBorder(ByVal BorderStyle As Word.WdLineStyle) As Word.WdLineStyle
        Select Case BorderStyle
            '--------------------------------------------------------
            Case Is = Word.WdLineStyle.wdLineStyleThinThickSmallGap
                Return Word.WdLineStyle.wdLineStyleThickThinSmallGap
            Case Is = Word.WdLineStyle.wdLineStyleThickThinSmallGap
                Return Word.WdLineStyle.wdLineStyleThinThickSmallGap
                '----------------------------------------------------
            Case Is = Word.WdLineStyle.wdLineStyleThinThickMedGap
                Return Word.WdLineStyle.wdLineStyleThickThinMedGap
            Case Is = Word.WdLineStyle.wdLineStyleThickThinMedGap
                Return Word.WdLineStyle.wdLineStyleThinThickMedGap
                '----------------------------------------------------
            Case Is = Word.WdLineStyle.wdLineStyleEmboss3D
                Return Word.WdLineStyle.wdLineStyleEngrave3D
            Case Is = Word.WdLineStyle.wdLineStyleEngrave3D
                Return Word.WdLineStyle.wdLineStyleEmboss3D
                '----------------------------------------------------
            Case Is = Word.WdLineStyle.wdLineStyleThinThickLargeGap
                Return Word.WdLineStyle.wdLineStyleThickThinLargeGap
            Case Is = Word.WdLineStyle.wdLineStyleThickThinLargeGap
                Return Word.WdLineStyle.wdLineStyleThinThickLargeGap
                '----------------------------------------------------
            Case Else
                Return BorderStyle
        End Select
    End Function


    Private Sub SetProgressCuonter()
        Try

            Me.PrintingSessionDialog.PrintProgressBar.Value += 1
            My.Application.DoEvents()
        Catch ex As Exception
        End Try
    End Sub

    Private Function SelectThisBookMark(ByVal BookMarkName As String) As Boolean
        Try
            Me.OfficeWord.ActiveDocument.Bookmarks(BookMarkName).Select()
            Return True
        Catch ex As Exception
            PrintingProcess.close()
            MsgBox("لم يتم العثور على العلامة" & vbNewLine & _
                   "BookMark Name : [ " & BookMarkName & "]", MsgBoxStyle.Critical, "BookMark Selection Error")
            Return False
        End Try
    End Function


    Private Function WriteTableContaint(ByVal TableJob As BookMarkTable) As Boolean

        Dim Cuonter As Integer = 0                       '<--- عداد الترقيم التلقائي
        Dim CurrentPage As Integer = 0                   '<--- رقم الصفحة الحالية
        Dim TableHeadLocation As Integer = 0             '<--- رقم الصفحة عند عنوان الجدول الرئيسي
        Dim TableStartPointLocation As Integer = 0       '<--- رقم الصفحة عند أول سطر في الجول
        Try


            '>>>> Start Writing Data Into the Table >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            '-- كتابة البيانات في الجدول
            If Not SelectThisBookMark(TableJob.HeadTableBookMarkName) Then Return False
            TableHeadLocation = Me.Document.ActiveWindow.Selection.Information(Word.WdInformation.wdActiveEndAdjustedPageNumber)

            For Each dr As DataRow In TableJob.Table.Rows

                Cuonter += 1
                If Cuonter = 1 Then
                    If Not SelectThisBookMark(TableJob.StartPointBookMarkName) Then Return False
                    TableStartPointLocation = Me.Document.ActiveWindow.Selection.Information(Word.WdInformation.wdActiveEndAdjustedPageNumber)
                Else
                    Me.OfficeWord.Selection.InsertRowsBelow(1)
                End If

                If TableJob.StartWithAutoNumberColumn Then
                    Me.OfficeWord.Selection.TypeText(Text:=Cuonter)
                    Me.OfficeWord.Selection.MoveRight(Unit:=Word.WdUnits.wdCell)
                End If

                Dim ColumnCuonter As Integer = 0
                For Each Clm As WordPrintingSession.Table.SengelColumn In TableJob.ColumnsOrder.Columns
                    ColumnCuonter += 1
                    Select Case Clm.ColumnType
                        Case Is = WordPrintingSession.Table.ColumnOrder.ColumnType.String
                            If Clm.GetColumnBy = WordPrintingSession.Table.ColumnOrder.ColumnGetMethod.ByName Then
                                Me.OfficeWord.Selection.TypeText(Text:=dr(Clm.ColumnName).ToString)
                            ElseIf Clm.GetColumnBy = WordPrintingSession.Table.ColumnOrder.ColumnGetMethod.ByIndex Then
                                Me.OfficeWord.Selection.TypeText(Text:=dr(Clm.ColumnIndex).ToString)
                            End If
                        Case Is = WordPrintingSession.Table.ColumnOrder.ColumnType.Image
                            If Clm.GetColumnBy = WordPrintingSession.Table.ColumnOrder.ColumnGetMethod.ByName Then
                                Dim ImageInfo As New BookMarkImage
                                If Clm.ImageSourceType = WordPrintingSession.Table.ColumnOrder.ColumnImageSourceType.FromBytesArray Then
                                    ImageInfo.Image = ConvertBytesToImage(dr(Clm.ColumnName))
                                ElseIf Clm.ImageSourceType = WordPrintingSession.Table.ColumnOrder.ColumnImageSourceType.FromFilePathString Then
                                    ImageInfo.Image = Image.FromFile(dr(Clm.ColumnName).ToString)
                                End If
                                ImageInfo.MaximumSize = Clm.ColumnImageStyle.MaximumSize
                                ImageInfo.BorderStyle = Clm.ColumnImageStyle.BorderStyle
                                ImageInfo.BorderSize = Clm.ColumnImageStyle.BorderSize
                                ImageInfo.BorderColor = Clm.ColumnImageStyle.BorderColor
                                WriteImage(ImageInfo)
                            ElseIf Clm.GetColumnBy = WordPrintingSession.Table.ColumnOrder.ColumnGetMethod.ByIndex Then
                                Dim ImageInfo As New BookMarkImage
                                If Clm.ImageSourceType = WordPrintingSession.Table.ColumnOrder.ColumnImageSourceType.FromBytesArray Then
                                    ImageInfo.Image = ConvertBytesToImage(dr(Clm.ColumnName))
                                ElseIf Clm.ImageSourceType = WordPrintingSession.Table.ColumnOrder.ColumnImageSourceType.FromFilePathString Then
                                    ImageInfo.Image = Image.FromFile(dr(Clm.ColumnName).ToString)
                                End If
                                ImageInfo.Image = ConvertBytesToImage(dr(Clm.ColumnIndex))
                                ImageInfo.MaximumSize = Clm.ColumnImageStyle.MaximumSize
                                ImageInfo.BorderStyle = Clm.ColumnImageStyle.BorderStyle
                                ImageInfo.BorderSize = Clm.ColumnImageStyle.BorderSize
                                ImageInfo.BorderColor = Clm.ColumnImageStyle.BorderColor
                                WriteImage(ImageInfo)
                            End If
                        Case Is = WordPrintingSession.Table.ColumnOrder.ColumnType.Empty
                            ' If Column Type Is Empty Column Then Do Nothing
                    End Select
                    If Not ((ColumnCuonter) = TableJob.ColumnsOrder.Columns.Count) Then
                        Me.OfficeWord.Selection.MoveRight(Unit:=Word.WdUnits.wdCell)
                    End If
                    SetProgressCuonter()
                    My.Application.DoEvents()
                Next
            Next
            '<<<< End Writing Data Into the Table <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<


            '>>>> Start Repair Table Head >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            '-- هذا القسم يختص بمعالجة مكان رأس الجدول
            '-- إذا كان ( مستند الوورد - أو القالب الذي صممتة والذي يتم كتابة البيانات فية الآن ) يحتوي على أكثر من جدول
            '-- لنفترض ان الجدول الأول وبعد الإنتهاء من الكتابة فية وصل إلى نهاية الصفحة من الأسفل  
            '-- وتبقى مكان صغير في أسفل الصفحة من الممكن ان يبداء رأس الجدول الثاني من هذا المكان الصغير
            '-- في هذة الحالة من الممكن ان يكون رأس الجدول الثاني في نهاية الصفحة ثم يتم كتابة البيانات في الصفحة التالية
            '-- في هذة الحالة ستكون الصفحة التالية لا تحتوي على رأس الجدول
            '-- في هذا القسم يتم تحريك الجدول إلى الصفحة التالية لتبداء برأس الجدول ثم البيانات مباشرتاً
            If Not SelectThisBookMark(TableJob.StartPointBookMarkName) Then Return False
            TableStartPointLocation = Me.Document.ActiveWindow.Selection.Information(Word.WdInformation.wdActiveEndAdjustedPageNumber)
            If TableHeadLocation <> TableStartPointLocation Then
                Do
                    If Not SelectThisBookMark(TableJob.HeadTableBookMarkName) Then Return False
                    Me.OfficeWord.Selection.MoveUp(Unit:=Word.WdUnits.wdLine, Count:=1)
                    Me.OfficeWord.Selection.TypeParagraph()
                    If Not SelectThisBookMark(TableJob.HeadTableBookMarkName) Then Return False
                    TableHeadLocation = Me.Document.ActiveWindow.Selection.Information(Word.WdInformation.wdActiveEndAdjustedPageNumber)
                    My.Application.DoEvents()
                Loop Until (TableHeadLocation = TableStartPointLocation)
            End If
            '<<<< End Repair Table Head <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<



            '>>>> Start Setting The Table Head For Each Page >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            '-- في هذا القسم يتم التحقق من أن الجدول يمتد على أكثر من صفحة أو لا
            '--  إذا كان يمتد على أكثر من صفحة يتم نسخ رأس الجدول ولصقه في رأس 
            '-- كل صفحة موجود عليها الجدول مع زيادة كلمة واحد لعنوان الجدول وهي ( تابع : ??????????????? ) علامة الإستفهام تعني 
            '-- النص الموجود في رأس الجدول
            If Not SelectThisBookMark(TableJob.StartPointBookMarkName) Then Return False
            Dim LastHeadPage As Integer = Me.Document.ActiveWindow.Selection.Information(Word.WdInformation.wdActiveEndAdjustedPageNumber)
            Me.OfficeWord.ActiveWindow.Selection.Tables.Item(1).Rows.Last.Select()
            CurrentPage = Me.Document.ActiveWindow.Selection.Information(Word.WdInformation.wdActiveEndAdjustedPageNumber)
            If CurrentPage <> LastHeadPage Then
                Me.OfficeWord.ActiveWindow.Selection.Tables.Item(1).Rows.First.Select()
                Me.OfficeWord.ActiveWindow.Selection.MoveDown(Unit:=Word.WdUnits.wdLine, Count:=1, Extend:=Word.WdMovementType.wdExtend)
                Me.OfficeWord.Selection.Copy()
                Do
                    My.Application.DoEvents()
                    Me.OfficeWord.Selection.MoveDown(Unit:=Word.WdUnits.wdLine, Count:=1)
                    CurrentPage = Me.Document.ActiveWindow.Selection.Information(Word.WdInformation.wdActiveEndAdjustedPageNumber)
                    If CurrentPage > LastHeadPage Then
                        Me.OfficeWord.Selection.SelectRow()
                        Me.OfficeWord.Selection.Paste()
                        My.Application.DoEvents()
                        Me.OfficeWord.Selection.MoveUp(Unit:=Word.WdUnits.wdLine, Count:=2)
                        Me.OfficeWord.Selection.HomeKey(Unit:=Word.WdUnits.wdLine)
                        BookMarkCuonter += 1
                        LastBookMarkContinues = Me.OfficeWord.ActiveDocument.Bookmarks.Add(Range:=Me.OfficeWord.Selection.Range, Name:="BokMrkCntnu" & BookMarkCuonter)
                        Me.OfficeWord.Selection.TypeText(Text:="تابع : ")
                        Me.OfficeWord.Selection.SelectRow()
                        Me.OfficeWord.Selection.SplitTable()
                        My.Application.DoEvents()
                        '>>>>>>>>>>>>>>>>>>>>>
                        If Not SelectThisBookMark(LastBookMarkContinues.Name) Then Return False
                        Dim TempCurrentPage As Integer = Me.Document.ActiveWindow.Selection.Information(Word.WdInformation.wdActiveEndAdjustedPageNumber)
                        Do While TempCurrentPage = LastHeadPage
                            Me.OfficeWord.Selection.MoveUp(Unit:=Word.WdUnits.wdLine, Count:=1)
                            Me.OfficeWord.Selection.TypeParagraph()
                            LastBookMarkContinues.Select()
                            TempCurrentPage = Me.Document.ActiveWindow.Selection.Information(Word.WdInformation.wdActiveEndAdjustedPageNumber)
                            My.Application.DoEvents()
                        Loop
                        '<<<<<<<<<<<<<<<<<<<<<
                        Me.OfficeWord.ActiveWindow.Selection.Tables.Item(1).Rows.Last.Select()
                        Dim LastRowPage As Integer = Me.Document.ActiveWindow.Selection.Information(Word.WdInformation.wdActiveEndAdjustedPageNumber)
                        If LastRowPage = CurrentPage Then
                            Exit Do
                        Else
                            If Not SelectThisBookMark(LastBookMarkContinues.Name) Then Return False
                        End If
                        LastHeadPage = CurrentPage
                    End If
                    My.Application.DoEvents()
                Loop
                My.Application.DoEvents()
            End If
            '<<<< End Setting The Table Head For Each Page <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
            Return True
        Catch ex As Exception
            PrintingProcess.ShowErrorMsgAndClose(ex.Message)
        End Try

    End Function




#Region " Add Print Job"
    '#######################################################################################
    Private Class BookMarkText
        Public BookMarkName As String
        Public Text As String
    End Class
    '#######################################################################################
    Private Class BookMarkImage
        Public BookMarkName As String
        Public Image As System.Drawing.Image
        Public MaximumSize As ImageMaximumSize
        Public BorderStyle As Word.WdLineStyle
        Public BorderSize As Word.WdLineWidth
        Public BorderColor As Word.WdColor
    End Class
    '#######################################################################################
    Public Class BookMarkTable
        Public Table As System.Data.DataTable
        Public ColumnsOrder As WordPrintingSession.Table.ColumnOrder
        Public HeadTableBookMarkName As String
        Public StartPointBookMarkName As String
        Public StartWithAutoNumberColumn As Boolean
    End Class
    '#######################################################################################
    Public Class ImageMaximumSize
        Public Sub New(ByVal Width As Integer, ByVal Height As Integer)
            Me.Width = Width
            Me.Height = Height
        End Sub
        Public Width As Integer
        Public Height As Integer
    End Class
    '#######################################################################################
    Public Class BookMarkDeletedTable
        Public HeadTableBookMarkName As String
    End Class
    '#######################################################################################




    Public Class Table
        Public Class SengelColumn
            Public GetColumnBy As WordPrintingSession.Table.ColumnOrder.ColumnGetMethod
            Public ColumnIndex As Integer
            Public ColumnName As String
            Public ColumnType As WordPrintingSession.Table.ColumnOrder.ColumnType
            Public ColumnImageStyle As New ImageStyle
            Public ImageSourceType As WordPrintingSession.Table.ColumnOrder.ColumnImageSourceType
        End Class
        '#######################################################################################
        Public Class ImageStyle
            Public MaximumSize As ImageMaximumSize
            Public BorderStyle As Word.WdLineStyle
            Public BorderColor As Word.WdColor
            Public BorderSize As Word.WdLineWidth
        End Class
        '#######################################################################################
        Public Class ColumnOrder
            Public Enum ColumnGetMethod
                ByName = 0
                ByIndex = 1
            End Enum
            Public Enum ColumnType
                [String] = 0
                [Image] = 1
                Empty = 2
            End Enum
            Public Enum ColumnImageSourceType
                FromBytesArray = 0
                FromFilePathString = 1
            End Enum
            Public Columns As New Collection
            Public ColumnsCuonter As Integer = 0
            Public Sub AddTextColumn(ByVal ColumnName As String)
                Try
                    Dim Col As New SengelColumn
                    Col.GetColumnBy = ColumnGetMethod.ByName
                    Col.ColumnName = ColumnName
                    Col.ColumnType = ColumnType.String
                    Columns.Add(Col)
                Catch ex As Exception
                    PrintingProcess.ShowErrorMsgAndClose(ex.Message)
                End Try
            End Sub
            Public Sub AddTextColumn(ByVal ColumnIndex As Integer)
                Try
                    Dim Col As New SengelColumn
                    Col.GetColumnBy = ColumnGetMethod.ByIndex
                    Col.ColumnIndex = ColumnIndex
                    Col.ColumnType = ColumnType.String
                    Columns.Add(Col)
                Catch ex As Exception
                    PrintingProcess.ShowErrorMsgAndClose(ex.Message)
                End Try
            End Sub
            Public Sub AddImageColumn(ByVal ColumnName As String, ByVal ImageSourceType As ColumnImageSourceType, _
                                      Optional ByVal MaximumSize As ImageMaximumSize = Nothing, _
                                      Optional ByVal ImageBorderStyle As Word.WdLineStyle = Nothing, _
                                      Optional ByVal ImageBorderColor As Word.WdColor = Nothing, _
                                      Optional ByVal ImageBorderSize As Word.WdLineWidth = Nothing)
                Try
                    Dim Clm As New SengelColumn
                    '---------------------------------------
                    Clm.GetColumnBy = ColumnGetMethod.ByName
                    Clm.ColumnName = ColumnName
                    Clm.ColumnType = ColumnType.Image
                    Clm.ImageSourceType = ImageSourceType
                    '---------------------------------------
                    Clm.ColumnImageStyle.MaximumSize = MaximumSize
                    Clm.ColumnImageStyle.BorderStyle = ImageBorderStyle
                    Clm.ColumnImageStyle.BorderColor = ImageBorderColor
                    Clm.ColumnImageStyle.BorderSize = ImageBorderSize
                    Columns.Add(Clm)
                Catch ex As Exception
                    PrintingProcess.ShowErrorMsgAndClose(ex.Message)
                End Try
            End Sub
            Public Sub AddImageColumn(ByVal ColumnIndex As Integer, ByVal ImageSourceType As ColumnImageSourceType, _
                                      Optional ByVal MaximumSize As ImageMaximumSize = Nothing, _
                                      Optional ByVal ImageBorderStyle As Word.WdLineStyle = Nothing, _
                                      Optional ByVal ImageBorderColor As Word.WdColor = Nothing, _
                                      Optional ByVal ImageBorderSize As Word.WdLineWidth = Nothing)
                Try
                    Dim Clm As New SengelColumn
                    '---------------------------------------
                    Clm.GetColumnBy = ColumnGetMethod.ByIndex
                    Clm.ColumnIndex = ColumnIndex
                    Clm.ColumnType = ColumnType.Image
                    Clm.ImageSourceType = ImageSourceType
                    '---------------------------------------
                    Clm.ColumnImageStyle.MaximumSize = MaximumSize
                    Clm.ColumnImageStyle.BorderStyle = ImageBorderStyle
                    Clm.ColumnImageStyle.BorderColor = ImageBorderColor
                    Clm.ColumnImageStyle.BorderSize = ImageBorderSize
                    Columns.Add(Clm)
                Catch ex As Exception
                    PrintingProcess.ShowErrorMsgAndClose(ex.Message)
                End Try
            End Sub
            Public Sub AddEmptyColumn()
                Try
                    Dim Clm As New SengelColumn
                    Clm.ColumnType = ColumnType.Empty
                    Columns.Add(Clm)
                Catch ex As Exception
                    PrintingProcess.ShowErrorMsgAndClose(ex.Message)
                End Try
            End Sub
        End Class
        '#######################################################################################
    End Class
    '#######################################################################################
    Public Class PrintJob                         '<----------- Start PrintJob Class
        Public PrintJobCollection As New Collection
        Public Sub AddText(ByVal Text As String, ByVal BookMarkName As String)
            Try
                If Not String.IsNullOrEmpty(Text) AndAlso Not String.IsNullOrEmpty(BookMarkName) Then
                    Dim PrintItem As New BookMarkText
                    PrintItem.BookMarkName = BookMarkName
                    PrintItem.Text = Text
                    Me.PrintJobCollection.Add(PrintItem)
                End If
            Catch ex As Exception
                PrintingProcess.ShowErrorMsgAndClose(ex.Message)
            End Try
        End Sub
        Public Sub AddImage(ByVal Image As System.Drawing.Image, _
                            ByVal BookMarkName As String, _
                            Optional ByVal MaximumSize As ImageMaximumSize = Nothing, _
                            Optional ByVal ImageBorderStyle As Word.WdLineStyle = Nothing, _
                            Optional ByVal ImageBorderColor As Word.WdColor = Nothing, _
                            Optional ByVal ImageBorderSize As Word.WdLineWidth = Nothing)
            Try
                If Image IsNot Nothing AndAlso Not String.IsNullOrEmpty(BookMarkName) Then
                    Dim PrintItem As New BookMarkImage
                    PrintItem.Image = Image
                    PrintItem.BookMarkName = BookMarkName
                    If MaximumSize IsNot Nothing Then
                        PrintItem.MaximumSize = MaximumSize
                    End If
                    If ImageBorderStyle <> Word.WdLineStyle.wdLineStyleNone Then
                        PrintItem.BorderStyle = ImageBorderStyle
                        PrintItem.BorderColor = ImageBorderColor
                        PrintItem.BorderSize = ImageBorderSize
                    End If
                    Me.PrintJobCollection.Add(PrintItem)
                End If
            Catch ex As Exception
                PrintingProcess.ShowErrorMsgAndClose(ex.Message)
            End Try
        End Sub
        Public Sub AddTable(ByVal DataTable As System.Data.DataTable, _
                            ByVal ColumnsOrder As WordPrintingSession.Table.ColumnOrder, _
                            ByVal HeadTableBookMarkName As String, _
                            ByVal StartPointBookMarkName As String, _
                   Optional ByVal StartWithAutoNumberColumn As Boolean = False)
            Try
                If DataTable IsNot Nothing AndAlso Not String.IsNullOrEmpty(StartPointBookMarkName) Then
                    Dim PrintItem As New BookMarkTable
                    PrintItem.Table = DataTable
                    PrintItem.ColumnsOrder = ColumnsOrder
                    PrintItem.HeadTableBookMarkName = HeadTableBookMarkName
                    PrintItem.StartPointBookMarkName = StartPointBookMarkName
                    PrintItem.StartWithAutoNumberColumn = StartWithAutoNumberColumn
                    Me.PrintJobCollection.Add(PrintItem)
                End If
            Catch ex As Exception
                PrintingProcess.ShowErrorMsgAndClose(ex.Message)
            End Try
        End Sub
        Public Sub DeleteTable(ByVal HeadTableBookMarkName As String)
            If Not String.IsNullOrEmpty(HeadTableBookMarkName) Then
                Dim PrintItem As New BookMarkDeletedTable
                PrintItem.HeadTableBookMarkName = HeadTableBookMarkName
                Me.PrintJobCollection.Add(PrintItem)
            End If
        End Sub

        Public Function GetPrintJobCuonter() As Integer
            Try
                Dim PrintJobCuonter As Integer = 0
                For Each Job As Object In Me.PrintJobCollection
                    If TypeOf Job Is WordPrintingSession.BookMarkTable Then
                        Dim PrintJob As BookMarkTable = Job
                        PrintJobCuonter += (PrintJob.ColumnsOrder.Columns.Count * PrintJob.Table.Rows.Count)
                    ElseIf TypeOf Job Is BookMarkText OrElse TypeOf Job Is BookMarkImage Then
                        PrintJobCuonter += 1
                    End If
                Next
                Return PrintJobCuonter
            Catch ex As Exception
                PrintingProcess.ShowErrorMsgAndClose(ex.Message)
            End Try
        End Function
    End Class                                       '<----------- End PrintJob Class
    '#######################################################################################
#End Region


    ''' <summary>
    ''' Convert a byte array to an Image
    ''' حول مصفوفة من البايتات إلى صورة
    ''' </summary>
    ''' <param name="ByteArray">مصفوفة البايتات المراد تحويلهل إلى صورة</param>
    ''' <remarks></remarks>
    Public Shared Function ConvertBytesToImage(ByVal ByteArray() As Byte) As Image
        Try
            If ByteArray.GetUpperBound(0) > 0 Then
                Return Image.FromStream(New System.IO.MemoryStream(ByteArray))
            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function



End Class






Public Module PrintingProcess

    Public _OfficeWord As Word.Application
    Public _ProgressWindow As System.Windows.Forms.Form
    Public _WordPrintingSession As WordPrintingSession
    Public _ImageHasSaved As Boolean = False
    Public _ImagePath As String = My.Application.Info.DirectoryPath & "\Temp"
    Public Sub ShowErrorMsgAndClose(ByVal ErrorMsg As String)
        close()
        MsgBox(ErrorMsg, MsgBoxStyle.Critical, "Printing Error")
    End Sub
    Public Sub close()
        Try
            If _ImageHasSaved Then
                Dim FileExist As Boolean = My.Computer.FileSystem.FileExists(_ImagePath)
                If FileExist Then
                    My.Computer.FileSystem.DeleteFile(_ImagePath, FileIO.UIOption.OnlyErrorDialogs, FileIO.RecycleOption.DeletePermanently)
                End If
            End If
            If _ProgressWindow IsNot Nothing AndAlso _ProgressWindow.Visible Then
                _ProgressWindow.Close()
            End If
            If _OfficeWord IsNot Nothing Then
                _OfficeWord.ActiveWindow.Close(False)
                _OfficeWord = Nothing
            End If

        Catch ex As Exception
        End Try
    End Sub
End Module

